# -*- coding: utf-8 -*-
"""
Created on Sat Sept 19 12:00:00 2015

@author: Julian

extract relevant scans from Spectra files and
plot results in various ways
"""



import numpy as np
import matplotlib.pyplot as plt
import xrayutilities as xu
import os.path
import numpy
import scipy as sp
import os
import h5py
import codecs



def CenOfMass(qx, qz, INT, roi):
    #Calculate the center of mass, for a give qx,qz, Int array and a roi in % arround center, returs a vector  
    qxs = 0.0
    qzs = 0.0
    qx_cen=0
    qz_cen=0
    var1 = 0
    var2 = 0
    rqx1=0
    rqx2=0
    rqz1=0
    rqz2=0
    int_ges=0.0
    
    #Find max. Int for Center Point of roi
    temp_arr = np.where(INT == INT.max());
    qz_cen = temp_arr[0][0]
    qx_cen = temp_arr[1][0]
    
    if roi==1:
        rqx1=0
        rqx2=qx.shape[0]
        rqz1=0
        rqz2=qz.shape[0]
    elif roi>1.:
        print("ROI for center of mass cannot be larger than 1!")
    else:
        rqx1=int(qx_cen-(roi*qx.shape[0]/2))
        rqx2=int(qx_cen+(roi*qx.shape[0]/2))
        rqz1=int(qz_cen-(roi*qz.shape[0]/2))
        rqz2=int(qz_cen+(roi*qz.shape[0]/2))  
        
    for var1 in range(rqx1,rqx2):
        
        for var2 in range(rqz1,rqz2):
            
            qxs=qxs+qx[var1]*INT[var2][var1]
            qzs=qzs+qz[var2]*INT[var2][var1]
            int_ges = int_ges +  INT[var2][var1]
            
    qxs = qxs/int_ges
    qzs = qzs/int_ges
    qs = np.array([qxs,qzs])
    
    return qs;


def check_filform(filepath):
    
    files = os.listdir(filepath)
    
    data = []
    for file in files:

        X = []
        with codecs.open(os.path.join(filepath,file), encoding='utf-8-sig') as f:
            X = [[float(x) for x in line.split()] for line in f]
        X = np.array(X)
        data.append(X[:,1])
        
    data = np.fliplr(np.array(data))  
    
    return (data)


def create_header(filefio):
    
    
    #Ceate Motor dictionary
    # Empty dictionary
    mot_counters = {}
    # Create entry for header indormation/motors
    mot_counters["header"] = []
    
    # Open file
    Data_from_FIO = open(filefio, 'r')
    
    #Count the number of of scan-points
    num_of_points = 0 
    for line in Data_from_FIO:
        if line[0] == " ":
            try: 
                #Check if second last charachter in this line is a number, if so increase counter
                float(line[-2])
                num_of_points = num_of_points+1
            except ValueError:
                num_of_points = num_of_points+0
                
    #Re-open file again to set line-counter to zero
    Data_from_FIO = open(filefio, 'r')
    
    #Set count variable for lines
    count=0         
    
    for line in Data_from_FIO:
        
        #Create motor-entries in dictionary mot_counters:
        if line[0]!=" " and line[0]!="!" and line[0]!="%" and count>13:
            columns = line.split()
            value_of_motor = np.float(columns[2])
            name_of_mot = columns[0]
            mot_counters[name_of_mot] = numpy.full(num_of_points, value_of_motor, dtype=float)
            count=count+1
            
        else:
            try:
                line.split().index("Col") #Check for Col description
                line = line.strip()
                columns = line.split()
                mot_counters["header"].append(columns[2]) #Store Col varaible in haeder
                mot_counters[columns[2]]=[]  #Create empty entry in dictionory according to Col variable  
                count=count+1
    
            except ValueError:
                columns = line.split()
                
            try:
                np.float(line.split()[0])
                header_count=0
                for i in columns:
                    mot_counters[mot_counters['header'][header_count]].append(np.float(i))
                    header_count = header_count + 1
                count=count+1
                
            except ValueError:
                count=count+1
    
    return(mot_counters)





plt.close("all") # remove all old open plot windows

# some definitions
incr = 10    # intensity increment to plot multiple scans

tickf = 20
labf = 20
plt.rcParams.update({'font.size': 20})
plt.rcParams['image.cmap'] = 'jet' 
white_text = 23


titf = 10
lw = 0.8
fontinset = 10
fontinset = 15
#plotinset = True

#Saves figures if set to "True"
sav = False
format = "png"
dpi = 900

# detector parameters
cch = 639.15
chpdeg = -309.94
roi1=[630,650] # for integration of PSD ROI1
roi2=[0,1280]  # for gridding in Q-space
#roi2=[200,1000]

# Energy
energy=15000  # eV

plfont = {'fontname':'Arial'}

GaAs = xu.materials.GaAs
Si = xu.materials.Si
Ge = xu.materials.Ge
SiGe = xu.materials.material.CubicAlloy(Si, Ge, 0.81)
SiGe2 = xu.materials.material.CubicAlloy(Si, Ge, 0.90)

GaAsWZ = xu.materials.Crystal.fromCIF(os.path.join("CIF", "GaAs_hex.cif"))


expcub = xu.HXRD(GaAs.Q(1,-1,0),GaAs.Q(1,1,1), geometry='lo_hi',wl=xu.lam2en(energy))
expwz = xu.HXRD(GaAsWZ.Q(1,0,0),GaAsWZ.Q(0,0,1), geometry='lo_hi',wl=xu.lam2en(energy))

#Define the path, sample-name
path=".\\raw\\"

# get nominal positions of peaks
qx444,qy444,qz444=expcub.Transform(GaAs.Q(4,4,4))
qx444ge,qy444ge,qz444ge=expcub.Transform(Ge.Q(4,4,4))
qx444,qy444,qz444=expcub.Transform(GaAs.Q(4,4,4))
qx444ge,qy444ge,qz444ge=expcub.Transform(Ge.Q(4,4,4))
qx335,qy335,qz335=expcub.Transform(GaAs.Q(3,3,5))

qx008wz,qy008wz,qz008wz=expwz.Transform(GaAsWZ.Q(0,0,8))


##########################################################################################################
#-------------------Pure GaAs-stems 444-az-448+60° ------------------------------------------------------------------------------
##########################################################################################################

sample = 'GaAs_NW_1stday'
samplename = 'GaAs-Cores_h05716'

titlestr = sample+" (444) az(448)+60°"
scannr ='00155'
fign='1'

#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)

#plt.ginput(1)
[uom, dummy, dummy , utt] = expcub.Q2Ang([0, 0.02938251730726643, 7.703875998048612], geometry = "real", trans=False)
[omth,dummy,dummy,ttth] = expcub.Q2Ang(GaAs.Q(4,4,4))
omoff = uom-omth
ttoff = utt-ttth
om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

[qx,qy,qz] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff,ttoff])
#convert to RSM

gridderSym = xu.FuzzyGridder2D(800,850)

mca_raw = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy,qz,mca_raw[:,roi2[0]:roi2[1]])

qxq444 = gridderSym.xaxis
qzq444 = gridderSym.yaxis
INT444 = xu.maplog(gridderSym.data.transpose(),7,1)

#plot
qxq = np.copy(qxq444) 
qzq = np.copy(qzq444) 
INT = np.copy(INT444)

exec("fig"+fign+" = plt.figure("+fign+"); plt.clf()")
exec("ax"+fign+" = fig"+fign+".add_subplot(231)")
exec("cf"+fign+" = plt.contourf(qxq,qzq,INT,100)")
plt.axis('normal')
plt.ylabel(r'$Q_{outofplane}$ ($\AA^{-1}$)',fontsize=labf,**plfont)

#GaAs 444 Subst.
plt.plot([qx444,qx444],[qz444-0.005,qz444+0.005],'k-',linewidth=lw)
plt.plot([qx444-0.005,qx444+0.005],[qz444,qz444],'k-',linewidth=lw)

#GaAs 0008 NW
plt.plot([qy008wz,qy008wz],[qz008wz-0.005,qz008wz+0.005],'k-',linewidth=lw)
plt.plot([qy008wz-0.005,qy008wz+0.005],[qz008wz,qz008wz],'k-',linewidth=lw)

plt.xlim(-0.055,0.055)
plt.ylim(7.6,7.80)

plt.yticks(np.arange(7.6, 7.8, step=0.05),fontsize=tickf,**plfont)

ax1.yaxis.set_tick_params(labelsize=21.5)
ax1.xaxis.set_major_formatter(plt.NullFormatter())


plt.tight_layout()



##########################################################################################################
#-------------------100%-Ge  444-az-448 ------------------------------------------------------------------------------  
##########################################################################################################
sample = 'GaAs_Ge_NW_2ndday'
samplename = 'GaAs-Cores-Ge-Shell_h05804'

    
titlestr = sample+" (444) az(448)"
scannr ='00245'
fign='1'

#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)

[uom,uchi,uphi,utt] = expcub.Q2Ang([0, 0.008988257724418398, 7.703202095451509], geometry = "real", trans=False)
[omth,dummy,dummy,ttth] = expcub.Q2Ang(GaAs.Q(4,4,4))
omoff = uom-omth
ttoff = utt-ttth
om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

#Correct for corrupted Scan
om = numpy.append(om, (om[-1]-om[-2]+om[-1]))
tt = numpy.append(tt, (tt[-1]-tt[-2]+tt[-1]))

[qx444_az448,qy444_az448,qz444_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff,ttoff])

gridderSym = xu.FuzzyGridder2D(1200,1250)

mca_raw444_az448 = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy444_az448,qz444_az448,mca_raw444_az448[:,roi2[0]:roi2[1]])

qxq444 = gridderSym.xaxis
qzq444 = gridderSym.yaxis
INT444 = xu.maplog(gridderSym.data.transpose(),7,1)

#plot
qxq = np.copy(qxq444) 
qzq = np.copy(qzq444) 
INT = np.copy(INT444)

exec("ax"+fign+" = fig"+fign+".add_subplot(232)")
exec("cf"+fign+" = plt.contourf(qxq,qzq,INT,100)")
plt.axis('normal')

#GaAs 444 Subst.
plt.plot([qx444,qx444],[qz444-0.005,qz444+0.005],'k-',linewidth=lw)
plt.plot([qx444-0.005,qx444+0.005],[qz444,qz444],'k-',linewidth=lw)

qz008ge100_wz = 7.64271
qy008ge100_wz = 0.0
plt.plot([qy008ge100_wz,qy008ge100_wz],[qz008ge100_wz-0.005,qz008ge100_wz+0.005],'k-',linewidth=lw)
plt.plot([qy008ge100_wz-0.005,qy008ge100_wz+0.005],[qz008ge100_wz,qz008ge100_wz],'k-',linewidth=lw)

plt.xlim(-0.055,0.055)
plt.ylim(7.6,7.80)

ax1.xaxis.set_major_formatter(plt.NullFormatter())
ax1.yaxis.set_major_formatter(plt.NullFormatter())


plt.tight_layout()


##########################################################################################################
#-------------------93%-Ge  -  444-az-448 ------------------------------------------------------------------------------
##########################################################################################################
    
sample = 'GaAs_SiGe93_h05797'
samplename = 'GaAs-Cores-SiGe93-Shell_h05797'


titlestr = sample+" (444) az(448)"
scannr ='00437'
fign='1'

#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)

[uom,uchi,uphi,utt] = expcub.Q2Ang([0, -0.011077928870986978, 7.703177366253125], geometry = "real", trans=False)
[omth,dummy,dummy,ttth] = expcub.Q2Ang(GaAs.Q(4,4,4))
omoff444 = uom-omth
ttoff444 = utt-ttth

om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

[qx444_az448,qy444_az448,qz444_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff444,ttoff444])

gridderSym = xu.FuzzyGridder2D(1200,1250)
gridderSym.KeepData(True)

mca_raw444_az448 = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy444_az448,qz444_az448,mca_raw444_az448[:,roi2[0]:roi2[1]])

qxq444 = gridderSym.xaxis
qzq444 = gridderSym.yaxis
INT444 = xu.maplog(gridderSym.data.transpose(),7,1)

#plot
qxq = np.copy(qxq444) 
qzq = np.copy(qzq444) 
INT = np.copy(INT444)

exec("ax"+fign+" = fig"+fign+".add_subplot(233)")
exec("cf"+fign+" = plt.contourf(qxq,qzq,INT,100)")
plt.axis('normal')

#GaAs 444 Subst.
plt.plot([qx444,qx444],[qz444-0.005,qz444+0.005],'k-',linewidth=lw)
plt.plot([qx444-0.005,qx444+0.005],[qz444,qz444],'k-',linewidth=lw)

qz008ge93_wz = 7.6692285
qy008ge93_wz = 0.0
plt.plot([qy008ge93_wz,qy008ge93_wz],[qz008ge93_wz-0.005,qz008ge93_wz+0.005],'k-',linewidth=lw)
plt.plot([qy008ge93_wz-0.005,qy008ge93_wz+0.005],[qz008ge93_wz,qz008ge93_wz],'k-',linewidth=lw)

plt.xlim(-0.055,0.055)
plt.ylim(7.6,7.80)

ax1.yaxis.set_major_formatter(plt.NullFormatter())
ax1.xaxis.set_major_formatter(plt.NullFormatter())

exec("cbar = plt.colorbar(cf"+fign+",ticks=[0.00, 0.60, 1.20, 1.80, 2.40, 3.00, 3.60, 4.20, 4.80, 5.4],format='%.1f')")
cbar.set_label(r'$\log($Int$)$ (cps)', fontsize=tickf,**plfont)



##########################################################################################################
#-------------------86%-Ge - 444-az-448 ------------------------------------------------------------------------------
##########################################################################################################
sample = 'GaAs_SiGe86_h05807'
samplename = 'GaAs-Cores-SiGe86-Shell_h05807'

titlestr = sample+" (444) az(448)"
scannr ='00327'
fign='1'

#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)


#plt.ginput(1)
[uom,uchi,uphi,utt] = expcub.Q2Ang([0, -0.0020857605297954765, 7.701966824633312], geometry = "real", trans=False) 
[omth,dummy,dummy,ttth] = expcub.Q2Ang(GaAs.Q(4,4,4))
omoff444 = uom-omth
ttoff444 = utt-ttth

om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

[qx444_az448,qy444_az448,qz444_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff444,ttoff444])

gridderSym = xu.FuzzyGridder2D(1200,1250)

mca_raw444_az448 = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy444_az448,qz444_az448,mca_raw444_az448[:,roi2[0]:roi2[1]])

qxq444 = gridderSym.xaxis
qzq444 = gridderSym.yaxis
INT444 = xu.maplog(gridderSym.data.transpose(),7,1)

#plot
qxq = np.copy(qxq444) 
qzq = np.copy(qzq444) 
INT = np.copy(INT444)

exec("ax"+fign+" = fig"+fign+".add_subplot(234)")
exec("cf"+fign+" = plt.contourf(qxq,qzq,INT,100)")
plt.axis('normal')

plt.ylabel(r'$Q_{outofplane}$ ($\AA^{-1}$)',fontsize=labf,**plfont)

#GaAs 444 Subst.
plt.plot([qx444,qx444],[qz444-0.005,qz444+0.005],'k-',linewidth=lw)
plt.plot([qx444-0.005,qx444+0.005],[qz444,qz444],'k-',linewidth=lw)

plt.plot([SiGe2qx444,SiGe2qx444],[SiGe2qz444-0.005,SiGe2qz444+0.005],'k-',linewidth=lw)
plt.plot([SiGe2qx444-0.005,SiGe2qx444+0.005],[SiGe2qz444,SiGe2qz444],'k-',linewidth=lw)


qz008ge86_wz = 7.682165646
qy008ge86_wz = 0.0
plt.plot([qy008ge86_wz,qy008ge86_wz],[qz008ge86_wz-0.005,qz008ge86_wz+0.005],'k-',linewidth=lw)
plt.plot([qy008ge86_wz-0.005,qy008ge86_wz+0.005],[qz008ge86_wz,qz008ge86_wz],'k-',linewidth=lw)

plt.xlim(-0.055,0.055)
plt.ylim(7.6,7.80)
plt.yticks(np.arange(7.6, 7.8, step=0.05),fontsize=tickf)
plt.xticks([-0.04,0.00, 0.04],fontsize=tickf)

plt.tight_layout()

##########################################################################################################
#-------------------77%-Ge 444-az-448 ------------------------------------------------------------------------------
##########################################################################################################
sample = 'GaAs_SiGe77_h05798'
samplename = 'GaAs-Cores-SiGe77-Shell_h05798'

titlestr = sample+" (444) az(448)"
scannr ='00405'
fign='1'

#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)

#correct sub pos
[uom,uchi,uphi,utt] = expcub.Q2Ang([0, -0.0018869144912283138, 7.703101076740555], geometry = "real", trans=False) 
[omth,dummy,dummy,ttth] = expcub.Q2Ang(GaAs.Q(4,4,4))
omoff = uom-omth
ttoff = utt-ttth

om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

[qx444_az448,qy444_az448,qz444_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff,ttoff])

gridderSym = xu.FuzzyGridder2D(1200,1250)

mca_raw444_az448 = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy444_az448,qz444_az448,mca_raw444_az448[:,roi2[0]:roi2[1]])

qxq444 = gridderSym.xaxis
qzq444 = gridderSym.yaxis
INT444 = xu.maplog(gridderSym.data.transpose(),7,2)

#plot
qxq = np.copy(qxq444) 
qzq = np.copy(qzq444) 
INT = np.copy(INT444)

exec("ax"+fign+" = fig"+fign+".add_subplot(235)")
exec("cf"+fign+" = plt.contourf(qxq,qzq,INT,100)")
plt.axis('normal')
plt.xlabel(r'$Q_{inplane}$ ($\AA^{-1}$)',fontsize=labf,**plfont)


#GaAs 444 Subst.
plt.plot([qx444,qx444],[qz444-0.005,qz444+0.005],'k-',linewidth=lw)
plt.plot([qx444-0.005,qx444+0.005],[qz444,qz444],'k-',linewidth=lw)

plt.plot([SiGeqx444,SiGeqx444],[SiGeqz444-0.005,SiGeqz444+0.005],'k-',linewidth=lw)
plt.plot([SiGeqx444-0.005,SiGeqx444+0.005],[SiGeqz444,SiGeqz444],'k-',linewidth=lw)


qz008ge77_wz = 7.702685
qy008ge77_wz = 0.0
plt.plot([qy008ge77_wz,qy008ge77_wz],[qz008ge77_wz-0.005,qz008ge77_wz+0.005],'k-',linewidth=lw)
plt.plot([qy008ge77_wz-0.005,qy008ge77_wz+0.005],[qz008ge77_wz,qz008ge77_wz],'k-',linewidth=lw)

plt.xlim(-0.055,0.055)
plt.ylim(7.6,7.80)
plt.xticks([-0.04,0.00, 0.04],fontsize=tickf)

ax1.yaxis.set_major_formatter(plt.NullFormatter())

plt.tight_layout()



##########################################################################################################
#-------------------63% Germanium - 444-az-448 ------------------------------------------------------------------------------
##########################################################################################################
sample = 'GaAs_SiGe67_h05798'
samplename = 'GaAs-Cores-Ge(67%)-Shell_h05789'

titlestr = sample+" (444) az(448)"
scannr ='00491'
fign='1'

#Combine Path + Filename
fnamefio='%s_%s'%(sample,scannr)

#Open FIO file    
filefio=os.path.join(path, fnamefio+".fio")
fiodata=os.path.join(path,sample+"_"+scannr,"mythen")

#Get Motor Values and detector images
mot_counters = []
mca_raw = []
mot_counters = create_header(filefio)
mca_raw = check_filform(fiodata)

#config psd
expcub.Ang2Q.init_linear('z+',cch,1280.,chpdeg=chpdeg,roi=roi2)

[uom,uchi,uphi,utt] = expcub.Q2Ang([0,  0.0018465351288981685, 7.70280410472817], geometry = "real", trans=False) 
[omth,dummy,dummy,ttth] = expcub.Q2Ang(GaAs.Q(4,4,4))
omoff = uom-omth
ttoff = utt-ttth

om = np.array(mot_counters["om"])
tt = np.array(mot_counters["tt"])

[qx444_az448,qy444_az448,qz444_az448] = expcub.Ang2Q.linear(om,tt,roi=roi2,delta=[omoff,ttoff])

gridderSym = xu.FuzzyGridder2D(1200,1250)

mca_raw444_az448 = xu.blockAveragePSD(mca_raw, 1, roi=roi2)

gridderSym(qy444_az448,qz444_az448,mca_raw444_az448[:,roi2[0]:roi2[1]])

qxq444 = gridderSym.xaxis
qzq444 = gridderSym.yaxis
INT444 = xu.maplog(gridderSym.data.transpose(),7,1) # 7,1

#plot
qxq = np.copy(qxq444) 
qzq = np.copy(qzq444) 
INT = np.copy(INT444)

exec("ax"+fign+" = fig"+fign+".add_subplot(236)")
exec("cf"+fign+" = plt.contourf(qxq,qzq,INT,100)")
plt.axis('normal')

#GaAs 444 Subst.
plt.plot([qx444,qx444],[qz444-0.005,qz444+0.005],'k-',linewidth=lw)
plt.plot([qx444-0.005,qx444+0.005],[qz444,qz444],'k-',linewidth=lw)

qz008ge60_wz = 7.76002873801433
qy008ge60_wz = 0.0
plt.plot([qy008ge60_wz,qy008ge60_wz],[qz008ge60_wz-0.005,qz008ge60_wz+0.005],'k-',linewidth=lw)
plt.plot([qy008ge60_wz-0.005,qy008ge60_wz+0.005],[qz008ge60_wz,qz008ge60_wz],'k-',linewidth=lw)


plt.xlim(-0.055,0.055)
plt.ylim(7.6,7.80)
plt.yticks(np.arange(7.6, 7.8, step=0.05),fontsize=tickf)
plt.xticks([-0.04,0.00, 0.04],fontsize=tickf)

ax1.yaxis.set_major_formatter(plt.NullFormatter())

exec("cbar = plt.colorbar(cf"+fign+",ticks=[0.00, 0.60, 1.20, 1.80, 2.40, 3.00, 3.60, 4.20, 4.80, 5.4],format='%.1f')")
cbar.set_label(r'$\log($Int$)$ (cps)', fontsize=tickf,**plfont)


plt.tight_layout()



########################################################################################


exec("fig"+fign+".set_size_inches(15, 15, forward=True)")

plt.tight_layout()

cf1 = plt.subplots_adjust(wspace = 0.02, hspace = 0.05)

if sav:
    plt.savefig("figures/For_Publication/"+"Combined_supplemetary_figure_High."+format, dpi=dpi)
    print("Figure saved")